/*
 * Decompiled with CFR 0.152.
 */
package HSR.Formular.GUI;

import HSR.Formular.GUI.FormularPageView;
import HSR.Formular.PD.Felder.AbstrakteFelder.AbstractCheckboxKlasse;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;

public class CheckBoxFeldView
extends JCheckBox
implements Observer {
    private AbstractCheckboxKlasse model;
    private FormularPageView view;
    private boolean isMouseOverField = false;

    public CheckBoxFeldView(FormularPageView v, AbstractCheckboxKlasse m) {
        this.view = v;
        this.model = m;
        Rectangle rect = this.model.getPosition();
        this.setBounds(rect.x + 5, rect.y + 5, rect.width, rect.height);
        this.setEnabled(this.model.getEditierbar());
        this.setSelected(this.model.getFeldValue());
        this.setToolTipText(this.model.getTooltip());
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                CheckBoxFeldView.this.isMouseOverField = true;
                CheckBoxFeldView.this.view.repaint();
            }

            public void mouseExited(MouseEvent e) {
                CheckBoxFeldView.this.isMouseOverField = false;
                CheckBoxFeldView.this.view.repaint();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CheckBoxFeldView.this.view.setVisible(CheckBoxFeldView.this.getBounds());
                CheckBoxFeldView.this.view.repaint();
            }

            public void focusLost(FocusEvent e) {
                CheckBoxFeldView.this.onEdit();
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CheckBoxFeldView.this.onEdit();
            }
        });
        this.model.addObserver(this);
    }

    protected void paintComponent(Graphics graphic) {
        Rectangle rect = this.getBounds();
        Graphics2D g2 = (Graphics2D)graphic;
        if (this.hasFocus() && this.isEnabled()) {
            graphic.setColor(Color.yellow);
            graphic.fill3DRect(0, 0, rect.width, rect.height, true);
        }
        if (this.isSelected()) {
            g2.drawImage(this.view.getCross(), 0, 0, rect.width, rect.height, this);
        }
    }

    public void paintBorder(Graphics graphic) {
        Rectangle rect = this.getBounds();
        Graphics2D g2 = (Graphics2D)graphic;
        if (this.isMouseOverField && this.isEnabled()) {
            g2.setColor(Color.blue);
            g2.setStroke(new BasicStroke(2.0f));
            g2.draw(new Rectangle(1, 1, rect.width - 2, rect.height - 2));
        }
    }

    public void update(Observable m, Object arg) {
        this.setSelected(this.model.getFeldValue());
        this.setEnabled(this.model.getEditierbar());
    }

    public void onEdit() {
        this.model.setFeldValue(this.isSelected());
        this.view.repaint();
    }

    public int getFeldNummer() {
        return this.model.getFeldNummer();
    }
}

