/*
 * Decompiled with CFR 0.152.
 */
package HSR.Formular.PD;

import HSR.Formular.PD.Felder.AbstrakteFelder.RFFeld;
import HSR.Formular.PD.FormularPage;
import HSR.Formular.PD.FormularPrinter;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Observable;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JOptionPane;

public class Formular
extends Observable
implements Serializable {
    public static final int NEXT_PAGE = 1;
    public static final int PREV_PAGE = 2;
    public static final int LAST_PAGE = 3;
    public static final int FIRST_PAGE = 4;
    private String formularName;
    private String fileName = "";
    private int pageNumberShown = 0;
    private int pageIter = 0;
    private transient FormularPrinter printer;
    private ArrayList formularPageList = new ArrayList();

    public Formular(String name) {
        this.formularName = name;
    }

    public FormularPage getFirstPage() {
        this.pageIter = 0;
        if (this.pageIter < this.formularPageList.size()) {
            return (FormularPage)this.formularPageList.get(this.pageIter);
        }
        return null;
    }

    public FormularPage getNextPage() {
        if (++this.pageIter < this.formularPageList.size()) {
            return (FormularPage)this.formularPageList.get(this.pageIter);
        }
        return null;
    }

    public int getPageCount() {
        return this.formularPageList.size();
    }

    public RFFeld getField(int key) {
        FormularPage page = this.getFirstPage();
        while (page != null) {
            RFFeld feld = page.getField(key);
            if (feld != null) {
                return feld;
            }
            page = this.getNextPage();
        }
        return null;
    }

    public void addFormularPage(FormularPage page) {
        this.formularPageList.add(page);
    }

    public boolean load(String file) {
        int i = 0;
        this.fileName = file;
        try {
            FileInputStream in = new FileInputStream(file);
            ObjectInputStream s = new ObjectInputStream(in);
            String name = (String)s.readObject();
            if (name.equals(this.formularName)) {
                Vector v = (Vector)s.readObject();
                FormularPage page = this.getFirstPage();
                while (page != null) {
                    page.setFieldList((TreeMap)v.get(i++));
                    page.generateViews();
                    page = this.getNextPage();
                }
                s.close();
                this.setChanged();
                this.notifyObservers();
                boolean bl = true;
                return bl;
            }
            s.close();
            JOptionPane.showMessageDialog(null, "Das sind Daten von einem anderen Formular!", "Fehler!", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Fehler!", 0);
        }
        return false;
    }

    public boolean save(String file, boolean temp) {
        Vector<TreeMap> v = new Vector<TreeMap>();
        if (!file.endsWith(".kszh")) {
            file = file.concat(".kszh");
        }
        if (!temp) {
            this.fileName = file;
        }
        try {
            ObjectOutputStream s = new ObjectOutputStream(new FileOutputStream(file));
            FormularPage page = this.getFirstPage();
            while (page != null) {
                v.add(page.getFieldList());
                page = this.getNextPage();
            }
            s.writeObject(this.formularName);
            s.writeObject(v);
            s.flush();
            s.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Fehler!", 0);
            return false;
        }
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = new PageFormat();
        Book book = new Book();
        Paper paper = new Paper();
        this.printer = new FormularPrinter(this, this.formularPageList.size());
        paper.setSize(595.0, 842.0);
        paper.setImageableArea(25.0, 25.0, 545.0, 786.0);
        pageFormat.setPaper(paper);
        book.append(this.printer, pageFormat, this.formularPageList.size());
        printerJob.setPageable(book);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "Fehler!", 0);
            }
        }
    }

    public FormularPage getPage(int page) {
        if (page < this.formularPageList.size() && page >= 0) {
            return (FormularPage)this.formularPageList.get(page);
        }
        return null;
    }

    public void changePage(int way) {
        switch (way) {
            case 1: {
                if (this.pageNumberShown >= this.formularPageList.size() - 1) break;
                ++this.pageNumberShown;
                break;
            }
            case 2: {
                if (this.pageNumberShown <= 0) break;
                --this.pageNumberShown;
                break;
            }
            case 3: {
                this.pageNumberShown = this.formularPageList.size() - 1;
                break;
            }
            case 4: {
                this.pageNumberShown = 0;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public int getPageNumberShown() {
        return this.pageNumberShown;
    }

    public String getFileName() {
        return this.fileName;
    }

    static {
        NEXT_PAGE = 1;
        PREV_PAGE = 2;
        LAST_PAGE = 3;
        FIRST_PAGE = 4;
    }
}

