/*
 * Decompiled with CFR 0.152.
 */
package HSR.Formular.PD;

import HSR.Formular.GUI.CheckBoxFeldView;
import HSR.Formular.GUI.FormularPageView;
import HSR.Formular.GUI.RadioButtonFeldView;
import HSR.Formular.GUI.TextFeldView;
import HSR.Formular.PD.Felder.AbstrakteFelder.AbstractCheckboxKlasse;
import HSR.Formular.PD.Felder.AbstrakteFelder.AbstractFeldKlasse;
import HSR.Formular.PD.Felder.AbstrakteFelder.AbstractRadiobuttonKlasse;
import HSR.Formular.PD.Felder.AbstrakteFelder.RFFeld;
import HSR.Formular.PD.Felder.CheckboxFeld;
import HSR.Formular.PD.Felder.RadiobuttonFeld;
import java.awt.Image;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.TreeMap;
import javax.swing.JComponent;

public class FormularPage
extends Observable
implements Serializable {
    private transient FormularPageView view;
    private String imageFile;
    private transient Image image;
    private transient Image cross;
    private TreeMap fieldList = new TreeMap();
    private transient List list;
    private transient Iterator iter;

    public FormularPage(String file) {
        this.imageFile = file;
    }

    public RFFeld getFirstField() {
        this.list = new ArrayList(this.fieldList.entrySet());
        this.iter = this.list.iterator();
        return this.getNextField();
    }

    public RFFeld getNextField() {
        if (this.iter.hasNext()) {
            Map.Entry me = (Map.Entry)this.iter.next();
            return (RFFeld)me.getValue();
        }
        return null;
    }

    public RFFeld getField(int key) {
        return (RFFeld)this.fieldList.get(new Integer(key));
    }

    public void addField(RFFeld feld) {
        this.fieldList.put(new Integer(feld.getFeldNummer()), feld);
    }

    public TreeMap getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(TreeMap f) {
        this.fieldList = f;
    }

    public FormularPageView getFormularPageView() {
        return this.view;
    }

    public void generateViews() {
        if (this.view == null) {
            this.view = new FormularPageView(this);
            this.view.setBackground(this.image);
            this.view.setCross(this.cross);
        } else {
            this.view.removeAll();
        }
        RFFeld feld = this.getFirstField();
        while (feld != null) {
            if (feld instanceof CheckboxFeld) {
                this.view.add(new CheckBoxFeldView(this.view, (AbstractCheckboxKlasse)feld));
            } else if (feld instanceof RadiobuttonFeld) {
                this.view.add(new RadioButtonFeldView(this.view, (AbstractRadiobuttonKlasse)feld));
            } else {
                this.view.add(new TextFeldView(this.view, (AbstractFeldKlasse)feld));
            }
            feld = this.getNextField();
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image b) {
        this.image = b;
    }

    public String getImageFile() {
        File file = new File(this.imageFile);
        return file.getName();
    }

    public String getImageFileFullPath() {
        return this.imageFile;
    }

    public Image getCross() {
        return this.cross;
    }

    public void setCross(Image c) {
        this.cross = c;
    }

    public void makeTabConnections() {
        RFFeld feld = this.getFirstField();
        while (feld != null) {
            JComponent destination;
            JComponent source = (JComponent)this.view.getField(feld.getFeldNummer());
            if (source != null && (destination = (JComponent)this.view.getField(feld.getNextTabPos())) != null) {
                source.setNextFocusableComponent(destination);
            }
            feld = this.getNextField();
        }
    }
}

