/*
 * Decompiled with CFR 0.152.
 */
package HSR.Formular.GUI;

import HSR.Formular.GUI.FormularPageView;
import HSR.Formular.GUI.SaveDialog;
import HSR.Formular.PD.Formular;
import HSR.Formular.PD.FormularPage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class FormularView
extends JPanel
implements Observer {
    private JButton saveB = new JButton();
    private JButton loadB = new JButton();
    private JButton printB = new JButton();
    private JButton firstB = new JButton();
    private JButton prevB = new JButton();
    private JButton nextB = new JButton();
    private JButton lastB = new JButton();
    private JScrollPane formularViewScroll = new JScrollPane();
    private JTextField pageF = new JTextField();
    private Formular formular;
    private ArrayList pageViewList = new ArrayList();
    private Dimension dimension;
    private String path;
    private SaveDialog dialog;

    public FormularView(Formular f, Dimension dim, Image[] images, String p) {
        this.formular = f;
        this.dimension = dim;
        this.path = p;
        try {
            this.jbInit(images);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.formular.addObserver(this);
    }

    public void onSaveAs() {
        this.dialog = new SaveDialog(this);
        ((Component)this.dialog).setVisible(true);
    }

    public void onSave() {
        if (this.formular.getFileName().length() != 0) {
            this.formular.save(this.formular.getFileName(), false);
        } else {
            this.onSaveAs();
        }
    }

    public void save(String filename) {
        this.formular.save(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.path))).append("/").append(filename))), false);
    }

    public void onPrint() {
        this.formular.print();
    }

    public void onNextPage() {
        this.formular.changePage(1);
    }

    public void onPrevPage() {
        this.formular.changePage(2);
    }

    public void onFirstPage() {
        this.formular.changePage(4);
    }

    public void onLastPage() {
        this.formular.changePage(3);
    }

    public void update(Observable model, Object arg) {
        if (this.formular.getPageNumberShown() < this.pageViewList.size()) {
            FormularPageView view = (FormularPageView)this.pageViewList.get(this.formular.getPageNumberShown());
            view.revalidate();
            this.formularViewScroll.getViewport().setViewPosition(new Point(0, 0));
            this.formularViewScroll.getViewport().setView(view);
            this.pageF.setText(String.valueOf(String.valueOf(new StringBuffer("Seite ").append(this.formular.getPageNumberShown() + 1).append("/").append(this.pageViewList.size()))));
        }
    }

    public void makeViews() {
        FormularPage page = this.formular.getFirstPage();
        while (page != null) {
            FormularPageView pageView = page.getFormularPageView();
            this.pageViewList.add(pageView);
            page = this.formular.getNextPage();
        }
        if (this.formular.getPageNumberShown() < this.pageViewList.size()) {
            this.formularViewScroll.getViewport().setView((FormularPageView)this.pageViewList.get(this.formular.getPageNumberShown()));
        }
        this.pageF.setText(String.valueOf(String.valueOf(new StringBuffer("Seite ").append(this.formular.getPageNumberShown() + 1).append("/").append(this.pageViewList.size()))));
    }

    public String getPfad() {
        return this.path;
    }

    private void jbInit(Image[] images) {
        Rectangle srollRect = new Rectangle(0, 0, this.dimension.width, this.dimension.height - 35);
        Rectangle saveRect = new Rectangle(this.dimension.width - 452, this.dimension.height - 27, 150, 27);
        Rectangle loadRect = new Rectangle(this.dimension.width - 301, this.dimension.height - 27, 150, 27);
        Rectangle printRect = new Rectangle(this.dimension.width - 150, this.dimension.height - 27, 150, 27);
        Rectangle firstRect = new Rectangle(0, this.dimension.height - 27, 27, 27);
        Rectangle prevRect = new Rectangle(28, this.dimension.height - 27, 27, 27);
        Rectangle nextRect = new Rectangle(154, this.dimension.height - 27, 27, 27);
        Rectangle lastRect = new Rectangle(182, this.dimension.height - 27, 27, 27);
        Rectangle pageRect = new Rectangle(59, this.dimension.height - 27, 90, 27);
        this.setLayout(null);
        this.formularViewScroll.setBounds(srollRect);
        this.saveB.setText("Speichern");
        this.saveB.setBounds(saveRect);
        this.saveB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FormularView.this.onSave();
            }
        });
        this.loadB.setText("Speichern unter...");
        this.loadB.setBounds(loadRect);
        this.loadB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FormularView.this.onSaveAs();
            }
        });
        this.printB.setText("Drucken");
        this.printB.setBounds(printRect);
        this.printB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FormularView.this.onPrint();
            }
        });
        this.firstB.setBounds(firstRect);
        this.firstB.setIcon(new ImageIcon(images[0]));
        this.firstB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FormularView.this.onFirstPage();
            }
        });
        this.prevB.setBounds(prevRect);
        this.prevB.setIcon(new ImageIcon(images[1]));
        this.prevB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FormularView.this.onPrevPage();
            }
        });
        this.nextB.setBounds(nextRect);
        this.nextB.setIcon(new ImageIcon(images[2]));
        this.nextB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FormularView.this.onNextPage();
            }
        });
        this.lastB.setBounds(lastRect);
        this.lastB.setIcon(new ImageIcon(images[3]));
        this.lastB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FormularView.this.onLastPage();
            }
        });
        this.pageF.setHorizontalAlignment(0);
        this.pageF.setEditable(false);
        this.pageF.setBounds(pageRect);
        this.setBackground(Color.white);
        this.setMaximumSize(this.dimension);
        this.setMinimumSize(this.dimension);
        this.setPreferredSize(this.dimension);
        this.add((Component)this.formularViewScroll, null);
        this.add((Component)this.saveB, null);
        this.add((Component)this.loadB, null);
        this.add((Component)this.printB, null);
        this.add((Component)this.firstB, null);
        this.add((Component)this.prevB, null);
        this.add((Component)this.lastB, null);
        this.add((Component)this.nextB, null);
        this.add((Component)this.pageF, null);
    }
}

